// Copyright (C) Mikko Apo (http://iki.fi/apo/)

/*
  Version History:
	1.0 Initial release
  CHANGELOG:
  -
  */

#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <string.h>
#include <windows.h>
#include "../mdk.h"

#include "NoteFilterTrack.h"
#include "BuzzParameterQ.h"
#include "BuzzParameterDuration.h"
#include "BuzzParameterUnit.h"
#include "BuzzParameterVolume.h"
#include "BuzzParameterFilterType.h"
#include "BuzzParameterSwitchADSR.h"

// Machine settings

// MT_GENERATOR or MT_EFFECT
#define miMACHINETYPE MT_EFFECT

// 0 or some CMachineInfo flags, MIF_DOES_INPUT_MIXING is for effect
#define miMACHINEFLAGS 0|MIF_DOES_INPUT_MIXING

#define miMACHINE_NAME "Geoffroy NoteFilter"
#define miSHORT_NAME "NoteFilter"
#define miMACHINE_AUTHOR "Geoffroy Montel (www.minizza.com)"
#define miCOMMAND_STRING "About..."
#define miMAX_TRACKS		10
#define miMIN_TRACKS		1
#define miNUMGLOBALPARAMETERS	19
#define miNUMTRACKPARAMETERS	2
#define miNUMATTRIBUTES		0
#define miVERSION "1.0"
#if miMACHINETYPE == MT_EFFECT
#define miMACHINETYPESTRING "[effect]"
#else
#define miMACHINETYPESTRING "[generator]"
#endif
#define miABOUTTXT miMACHINE_NAME" "miMACHINETYPESTRING"\n\nGeoffroy NoteFilter.dll build date: "__DATE__"\nVersion: "miVERSION"\nCode by: "miMACHINE_AUTHOR"\n"

// beta warning displays a nagging requester each time the machine is started
// the requester can be disabled from the attributes
// to enable, set to 1
// firstTick gets compiled in
#define miBETAWARNING 0

// machine is always stero if this flag is set to true, only MDKWorkStereo is called
// to enable, set to 1
#define miISALWAYSSTEREO 1

// add code which will notice samplerate changes caused by the host
// to enable, set to 1
// mi->samplerate value gets compiled in
//#undef miNOTIFYONSAMPLERATECHANGES
#define miNOTIFYONSAMPLERATECHANGES 1

#if miBETAWARNING > 0

#define miBETAWARNINGATTRIBUTE 1
CMachineAttribute const attrBetaWarning = { "Disable Preview Warning" ,0,1,0 };
#define miBETAWARNINGTXT "WARNING: This is a preview version of "miMACHINE_NAME" (version "miVERSION ")"\
	"\nDO NOT use this machine in your tracks or they might break\n" \
	"when newer versions are released.\n" \
	"If you use this machine, don't save your song with it.\n" \
	"\n(You can override this warning from the attributes,\n " \
	"but you need to save your song to save the setting.\n" \
	"\n" miMACHINE_AUTHOR " / "__DATE__

#else
#define miBETAWARNINGATTRIBUTE 0
#endif

//	Parameters

/*

  // examples

CMachineParameter const paraWord = 
{ pt_word, "Desc","Long desc",0,0xfffe,0xffff,MPF_STATE,0};

CMachineParameter const paraByte = 
{ pt_byte, "Desc","Long",0,0xfe,0xff,MPF_STATE,0};

CMachineParameter const paraSwitch = 
{ pt_switch, "Desc","Long",SWITCH_OFF,SWITCH_ON,SWITCH_NO,MPF_STATE,SWITCH_OFF};

CMachineParameter const paraNote = 
{ pt_note, "Desc","Long",NOTE_MIN,NOTE_OFF,NOTE_NO,MPF_STATE,10 };
*/

	// insert your own parameters below

CMachineParameter const paraFilterType = 
{ pt_byte, "Filter","Filter type",BuzzParameterFilterType.MIN_SLIDER_VALUE,BuzzParameterFilterType.MAX_SLIDER_VALUE,BuzzParameterFilterType.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterFilterType::INIT_SLIDER_VALUE};

CMachineParameter const paraQ = 
{ pt_word, "Q","Q",BuzzParameterQ.MIN_SLIDER_VALUE,BuzzParameterQ.MAX_SLIDER_VALUE,BuzzParameterQ.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterQ::INIT_SLIDER_VALUE};

CMachineParameter const paraUnit = 
{ pt_byte, "Unit","Unit for inertia",BuzzParameterUnit.MIN_SLIDER_VALUE,BuzzParameterUnit.MAX_SLIDER_VALUE,BuzzParameterUnit.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterUnit::INIT_SLIDER_VALUE};

CMachineParameter const paraInertia = 
{ pt_word, "Inertia","Inertia",BuzzParameterDuration.MIN_SLIDER_VALUE,BuzzParameterDuration.MAX_SLIDER_VALUE,BuzzParameterDuration.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterDuration::INIT_SLIDER_VALUE};

CMachineParameter const paraVolumeHarmo0 = 
{ pt_word, "Fundamental","Fundamental Volume",BuzzParameterVolume.MIN_SLIDER_VALUE,BuzzParameterVolume.MAX_SLIDER_VALUE,BuzzParameterVolume.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterVolume::INIT_SLIDER_VALUE};

CMachineParameter const paraVolumeHarmo1 = 
{ pt_word, "1st harmo","1st harmonic volume",BuzzParameterVolume.MIN_SLIDER_VALUE,BuzzParameterVolume.MAX_SLIDER_VALUE,BuzzParameterVolume.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterVolume::INIT_SLIDER_VALUE};

CMachineParameter const paraVolumeHarmo2 = 
{ pt_word, "2nd harmo","2nd harmonic volume",BuzzParameterVolume.MIN_SLIDER_VALUE,BuzzParameterVolume.MAX_SLIDER_VALUE,BuzzParameterVolume.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterVolume::INIT_SLIDER_VALUE};

CMachineParameter const paraVolumeHarmo3 = 
{ pt_word, "3nd harmo","3rd harmonic volume",BuzzParameterVolume.MIN_SLIDER_VALUE,BuzzParameterVolume.MAX_SLIDER_VALUE,BuzzParameterVolume.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterVolume::INIT_SLIDER_VALUE};

CMachineParameter const paraVolumeHarmo4 = 
{ pt_word, "4th harmo","4th harmonic volume",BuzzParameterVolume.MIN_SLIDER_VALUE,BuzzParameterVolume.MAX_SLIDER_VALUE,BuzzParameterVolume.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterVolume::INIT_SLIDER_VALUE};

CMachineParameter const paraVolumeHarmo5 = 
{ pt_word, "5th harmo","5th harmonic volume",BuzzParameterVolume.MIN_SLIDER_VALUE,BuzzParameterVolume.MAX_SLIDER_VALUE,BuzzParameterVolume.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterVolume::INIT_SLIDER_VALUE};

CMachineParameter const paraVolumeHarmo6 = 
{ pt_word, "6th harmo","6th harmonic volume",BuzzParameterVolume.MIN_SLIDER_VALUE,BuzzParameterVolume.MAX_SLIDER_VALUE,BuzzParameterVolume.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterVolume::INIT_SLIDER_VALUE};

CMachineParameter const paraVolumeHarmo7 = 
{ pt_word, "7th harmo","7th harmonic volume",BuzzParameterVolume.MIN_SLIDER_VALUE,BuzzParameterVolume.MAX_SLIDER_VALUE,BuzzParameterVolume.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterVolume::INIT_SLIDER_VALUE};

CMachineParameter const paraVolumeHarmo8 = 
{ pt_word, "8th harmo","8th harmonic volume",BuzzParameterVolume.MIN_SLIDER_VALUE,BuzzParameterVolume.MAX_SLIDER_VALUE,BuzzParameterVolume.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterVolume::INIT_SLIDER_VALUE};

CMachineParameter const paraVolumeHarmo9 = 
{ pt_word, "9th harmo","9th harmonic volume",BuzzParameterVolume.MIN_SLIDER_VALUE,BuzzParameterVolume.MAX_SLIDER_VALUE,BuzzParameterVolume.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterVolume::INIT_SLIDER_VALUE};

CMachineParameter const paraSwitchADSR = 
{ pt_byte, "ADSR","ADSR",BuzzParameterSwitchADSR.MIN_SLIDER_VALUE,BuzzParameterSwitchADSR.MAX_SLIDER_VALUE,BuzzParameterSwitchADSR.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterSwitchADSR::INIT_SLIDER_VALUE};

CMachineParameter const paraA = 
{ pt_word, "A","A",BuzzParameterDuration.MIN_SLIDER_VALUE,BuzzParameterDuration.MAX_SLIDER_VALUE,BuzzParameterDuration.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterDuration::INIT_SLIDER_VALUE};

CMachineParameter const paraD = 
{ pt_word, "D","D",BuzzParameterDuration.MIN_SLIDER_VALUE,BuzzParameterDuration.MAX_SLIDER_VALUE,BuzzParameterDuration.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterDuration::INIT_SLIDER_VALUE};

CMachineParameter const paraS = 
{ pt_word, "S","S",BuzzParameterDuration.MIN_SLIDER_VALUE,BuzzParameterDuration.MAX_SLIDER_VALUE,BuzzParameterDuration.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterDuration::INIT_SLIDER_VALUE};

CMachineParameter const paraR = 
{ pt_word, "R","R",BuzzParameterDuration.MIN_SLIDER_VALUE,BuzzParameterDuration.MAX_SLIDER_VALUE,BuzzParameterDuration.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterDuration::INIT_SLIDER_VALUE};

CMachineParameter const paraNote = 
{ pt_note, "Note","Note",NOTE_MIN,NOTE_OFF,NOTE_NO,0,0 };

CMachineParameter const paraTrackVolume = 
{ pt_word, "Volume","Volume",BuzzParameterVolume.MIN_SLIDER_VALUE,BuzzParameterVolume.MAX_SLIDER_VALUE,BuzzParameterVolume.UNCHANGED_SLIDER_VALUE,MPF_STATE,BuzzParameterVolume::INIT_SLIDER_VALUE};

	// end of insert

// List of all parameters, track parameters last

CMachineParameter const *pParameters[] = {
#if (miNUMGLOBALPARAMETERS + miNUMTRACKPARAMETERS) == 0
	NULL
#endif

	// &paraWord,&paraByte,&paraSwitch,&paraNote // example
	// insert your own parameters below
	
	&paraFilterType,&paraQ,&paraUnit,&paraInertia,
	&paraVolumeHarmo0,&paraVolumeHarmo1,&paraVolumeHarmo2,&paraVolumeHarmo3,&paraVolumeHarmo4,
	&paraVolumeHarmo5,&paraVolumeHarmo6,&paraVolumeHarmo7,&paraVolumeHarmo8,&paraVolumeHarmo9,
	&paraSwitchADSR,&paraA,&paraD,&paraS,&paraR,
	&paraNote,&paraTrackVolume

	// end of insert
};

// This assigns a number to the parameter, used by DescribeValue
// Fill in your own parameters
// used by Decribe() and maybe other places
// enum {PARAM_WORD,PARAM_BYTE,PARAM_SWITCH,PARAM_NOTE} miPARAMETERS;
enum {PARAM_FILTERTYPE,PARAM_Q,PARAM_UNIT,PARAM_INERTIA,
PARAM_VOLUMEHARMO_0,PARAM_VOLUMEHARMO_1,PARAM_VOLUMEHARMO_2,PARAM_VOLUMEHARMO_3,PARAM_VOLUMEHARMO_4,
PARAM_VOLUMEHARMO_5,PARAM_VOLUMEHARMO_6,PARAM_VOLUMEHARMO_7,PARAM_VOLUMEHARMO_8,PARAM_VOLUMEHARMO_9,
PARAM_SWITCH_ADSR,PARAM_A,PARAM_D,PARAM_S,PARAM_R,
PARAM_NOTE,PARAM_TRACK_VOLUME} miPARAMETERS;

// Attributes

	// CMachineAttribute const attrTime = { "Time in ms" ,0,128,0 };
	// insert your own attributes below


	// end of insert

// List of all attributes

CMachineAttribute const *pAttributes[] = {
#if (miNUMATTRIBUTES + miBETAWARNINGATTRIBUTE )== 0
	NULL
#endif

	//	&attrTime	// Example
	// insert your own attributes below


	// end of insert

#if miBETAWARNING > 0
#if miNUMATTRIBUTES > 0
,
#endif
// beta warning belongs to as the last attribute
	&attrBetaWarning
#endif
};

#pragma pack(1)

#if miNUMGLOBALPARAMETERS>0

// storage for global parameters, updated every Tick()
class gvals {
public:
//	word wordparam;		// word		// Example
//	byte byteparam;		// byte
//	byte switchparam;	// switch
//	byte noteparam;		// note

	// insert your global parameters here

	byte filtertype;
	word q;
	byte unit;
	word inertia;
	word harmovolume[NoteFilterTrack_NB_HARMONICS];
	byte switchADSR;
	word a;
	word d;
	word s;
	word r;

	// end of insert
};
#endif

#if (miMAX_TRACKS>0 && miNUMTRACKPARAMETERS>0)

// storage for track parameters, updated every Tick()
class tvals {
public:
	// insert your track parameters here

	byte note;
	word volume;
	// end of insert
};
#endif

#if (miNUMATTRIBUTES + miBETAWARNINGATTRIBUTE )>0

// storage for attributes, updated after MDKInit() and AttributesChanged
class avals {
public:
// 	int time;	// example


	// insert your attribute parameters here


	// end of insert

#if miBETAWARNING >0
	int betawarning;
#endif
};
#endif

#pragma pack()


// Machine's info

CMachineInfo const MacInfo = {
	miMACHINETYPE,MI_VERSION,miMACHINEFLAGS,miMIN_TRACKS,miMAX_TRACKS,
	miNUMGLOBALPARAMETERS,miNUMTRACKPARAMETERS,pParameters,
	miNUMATTRIBUTES+miBETAWARNINGATTRIBUTE,pAttributes,
	miMACHINE_NAME
#ifdef _DEBUG
	" [DEBUG]"
#endif
	,miSHORT_NAME,miMACHINE_AUTHOR,miCOMMAND_STRING
};

class miex : public CMDKMachineInterfaceEx {

};

class mi : public CMDKMachineInterface {
public:
	mi();
	~mi();

// Buzz calls these functions
	void Command(int const i);
	void Tick();
	char const *DescribeValue(int const param, int const value);
	void MDKInit(CMachineDataInput * const pi);
	bool MDKWork(float *psamples, int numsamples, int const mode);
	bool MDKWorkStereo(float *psamples, int numsamples, int const mode);
	void MDKSave(CMachineDataOutput * const po) { }
	CMDKMachineInterfaceEx *GetEx() { return &ex; }
	void OutputModeChanged(bool stereo);
	void AttributesChanged();
	void MidiNote(int const channel, int const value, int const velocity);
	void Stop();

	public:
		void filterTypeChanged();
	miex ex;
#if miNUMGLOBALPARAMETERS>0
	gvals gval;
#endif
#if (miNUMATTRIBUTES + miBETAWARNINGATTRIBUTE )>0
	avals aval;
#endif
#if (miMAX_TRACKS>0 && miNUMTRACKPARAMETERS>0)
	void SetNumTracks(int const n);
	tvals tval[miMAX_TRACKS];
#endif

private:


#if (miMAX_TRACKS>0 && miNUMTRACKPARAMETERS>0)
	unsigned int miNumberOfTracks;	// contains the number of tracks in use
#endif

#if (miBETAWARNING)> 0
	bool firstTick;
#endif

#if miNOTIFYONSAMPLERATECHANGES>0
	unsigned int samplerate;
#endif

	unsigned int samplesPerTick;

	// insert your machine's global variables here

	BuzzParameterFilterType filterType;
	BuzzParameterQ q;
	BuzzParameterDuration inertia;
	BuzzParameterUnit unit;
	BuzzParameterVolume harmoVolumes[NoteFilterTrack_NB_HARMONICS];
	BuzzParameterDuration a;
	BuzzParameterDuration d;
	BuzzParameterDuration s;
	BuzzParameterDuration r;
	BuzzParameterSwitchADSR switchADSR;

	float * trackBufferTemp;
	int trackBufferTempSize;
	float * mixBufferTemp;
	int mixBufferTempSize;

	// end of insert

#if (miMAX_TRACKS>0 && miNUMTRACKPARAMETERS>0)
	struct mytvals {
	// insert your machine's track's own variables here

	NoteFilterTrack noteFilterTrack;	
	BuzzParameterVolume volume;

	// end of insert
	} mytval[miMAX_TRACKS];
#endif

protected:
	void unitChanged();
	void inertiaChanged();
};

